/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.Parser;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ToggleAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Toggle toggle;
    private String nameWhenOn;
    private String nameWhenOff;
    private ImageIcon iconWhenOn;
    private ImageIcon iconWhenOff;

    ToggleAction(String string, String string2, Toggle toggle) {
        super(string);
        this.toggle = toggle;
        this.nameWhenOff = string;
        this.nameWhenOn = string2;
        this.putValue("actionConstants.selected", Boolean.FALSE);
    }

    ToggleAction(String string, String string2, Toggle toggle, KeyStroke keyStroke, int n) {
        this(string, string2, toggle);
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
        }
    }

    ToggleAction(String string, String string2, Toggle toggle, URL uRL, URL uRL2) {
        this(string, string2, toggle);
        this.putValue("SmallIcon", new ImageIcon(uRL));
        this.iconWhenOff = new ImageIcon(uRL);
        this.iconWhenOn = new ImageIcon(uRL2);
    }

    ToggleAction(String string, String string2, Toggle toggle, boolean bl, URL uRL, URL uRL2) {
        super(bl ? string2 : string);
        this.toggle = toggle;
        this.nameWhenOff = string;
        this.nameWhenOn = string2;
        this.putValue("actionConstants.selected", bl);
        this.putValue("SmallIcon", new ImageIcon(bl ? uRL2 : uRL));
        this.iconWhenOff = new ImageIcon(uRL);
        this.iconWhenOn = new ImageIcon(uRL2);
    }

    ToggleAction(String string, String string2, Toggle toggle, URL uRL, URL uRL2, KeyStroke keyStroke, int n) {
        this(string, string2, toggle, keyStroke, n);
        this.putValue("SmallIcon", new ImageIcon(uRL));
        this.iconWhenOff = new ImageIcon(uRL);
        this.iconWhenOn = new ImageIcon(uRL2);
    }

    public boolean isTrue() {
        return this.getValue("actionConstants.selected").equals(Boolean.TRUE);
    }

    public void setValue(boolean bl) {
        this.putValue("actionConstants.selected", bl);
    }

    public void updateAppearance() {
        if (this.getValue("actionConstants.selected").equals(Boolean.TRUE)) {
            this.putValue("Name", this.nameWhenOn);
            if (this.iconWhenOn != null) {
                this.putValue("SmallIcon", this.iconWhenOn);
            }
        } else {
            this.putValue("Name", this.nameWhenOff);
            if (this.iconWhenOff != null) {
                this.putValue("SmallIcon", this.iconWhenOff);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateAppearance();
        this.updateExternalVariables();
    }

    private void updateExternalVariables() {
        switch (this.toggle) {
            case DDCCI: 
            case EDID: 
            case HDCP: 
            case CEC: 
            case EVENTS: 
            case OTHERS: 
            case ERRORSONLY: {
                Parser.packets.updateFilteredTrace();
                break;
            }
            case CAPTURE: {
                Sniffer.window.setCaptureStatus((Boolean)this.getValue("actionConstants.selected"));
                break;
            }
            case PAUSE: {
                Sniffer.window.setPauseStatus((Boolean)this.getValue("actionConstants.selected"));
                break;
            }
            case TPA5VOLT: {
                Parser.enable5VoltTPA((Boolean)this.getValue("actionConstants.selected"));
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Toggle {
        CAPTURE,
        PAUSE,
        DDCCI,
        EDID,
        HDCP,
        CEC,
        EVENTS,
        OTHERS,
        ERRORSONLY,
        HIGHLIGHT,
        CONFIRMNEW,
        CONFIRMEXIT,
        PEDANTIC,
        STATETRACE,
        TPA5VOLT;

    }
}

